//
//  BridgeProtocol.m
//  testplay
//

#import "BridgeProtocol.h"

@implementation BridgeProtocol {
    
}

+ (BOOL)canInitWithRequest:(NSURLRequest *)request {
    if ([request.URL.absoluteString containsString:@"mybridgehostkey"]) {
        return YES;
    }
    return NO;
}

+ (NSURLRequest *)canonicalRequestForRequest:(NSURLRequest *)request {
    return request;
}

- (void)startLoading {
    NSURL *url = self.request.URL;
    NSDictionary * const responseHeaderFields = @{
                                                  @"Content-Type": @"text/plain"
                                                  };
    NSHTTPURLResponse *response = [[NSHTTPURLResponse alloc] initWithURL:url statusCode:200 HTTPVersion:@"HTTP/1.1" headerFields:responseHeaderFields];
    [self.client URLProtocol:self didReceiveResponse:response cacheStoragePolicy:NSURLCacheStorageAllowed];
    [self.client URLProtocol:self didLoadData:[@"[1,2,3]" dataUsingEncoding:NSUTF8StringEncoding]];//直接mock结果
    [self.client URLProtocolDidFinishLoading:self];
}

- (void)stopLoading {
    [self.client URLProtocol:self didFailWithError:[NSError errorWithDomain:@"BridgeProtocol" code:404 userInfo:nil]];
}

@end
