//
//  TestObject.m
//  testplay
//

#import "JscoreBridgeTester.h"

static dispatch_queue_t webcore_queue() {
    static dispatch_queue_t webcore_queue;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        webcore_queue = dispatch_get_main_queue();//dispatch_queue_create("com.lrdcq.webcore_queue", DISPATCH_QUEUE_CONCURRENT);
    });

    return webcore_queue;
}

NSString * JSStringRef2NSString(JSStringRef jsString) {
    size_t maxBufferSize = JSStringGetMaximumUTF8CStringSize(jsString);
    char *utf8Buffer = new char[maxBufferSize];
    JSStringGetUTF8CString(jsString, utf8Buffer, maxBufferSize);
    NSString *str = [NSString stringWithUTF8String:utf8Buffer];
    delete [] utf8Buffer;
    return str;
}

void NSLogJSStringRef(NSString *format, JSStringRef jsString) {
    NSLog(format, JSStringRef2NSString(jsString));
}

JSValueRef logImp(JSContextRef ctx, JSObjectRef function, JSObjectRef thisObject, size_t argumentCount, const JSValueRef arguments[], JSValueRef* exception) {
    if (argumentCount) {
        JSValueRef err = nullptr;
        JSStringRef jsString = JSValueToStringCopy(ctx, arguments[0], &err);
        if (!err) {
            NSLogJSStringRef(@"[say] %@", jsString);
        } else {
            NSLog(@"[jsSayError]");
        }

    }
    return JSValueMakeUndefined(ctx);
}

JSValueRef syncBridgeImp(JSContextRef ctx, JSObjectRef function, JSObjectRef thisObject, size_t argumentCount, const JSValueRef arguments[], JSValueRef* exception) {
    if (argumentCount >= 3) {
        JSStringRef key;
        //读取参数1，字符串
        JSStringRef moduleName = JSValueToStringCopy(ctx, arguments[0], nullptr);
        //NSLogJSStringRef(@"[syncBridge] moduleName = %@", moduleName);
        
        //读取参数2，字符串
        JSStringRef method = JSValueToStringCopy(ctx, arguments[1], nullptr);
        //NSLogJSStringRef(@"[syncBridge] method = %@", method);
        
        //读取参数3，数组，遍历其内容
        JSObjectRef array = JSValueToObject(ctx, arguments[2], nullptr);
        key = JSStringCreateWithUTF8CString("length");
        NSUInteger length = JSValueToNumber(ctx, JSObjectGetProperty(ctx, array, key, nullptr), nullptr);
        JSStringRelease(key);
        
        for (NSUInteger i = 0; i < length; i++) {
            //NSLogJSStringRef([NSString stringWithFormat:@"[syncBridge] array[%ld] %%@", i], JSValueToStringCopy(ctx, JSObjectGetPropertyAtIndex(ctx, array, (unsigned int)i, nullptr), nullptr));
        }
        
        //构成返回对象
        /*
         {
            "moduleName":moduleName,
            "method":method,
            "data":
         }
         */
        JSObjectRef result = JSObjectMake(ctx, nullptr, nullptr);
        key = JSStringCreateWithUTF8CString("moduleName");
        JSObjectSetProperty(ctx, result, key, JSValueMakeString(ctx, moduleName),kJSPropertyAttributeNone, nullptr);
        JSStringRelease(key);
        key = JSStringCreateWithUTF8CString("method");
        JSObjectSetProperty(ctx, result, key, JSValueMakeString(ctx, method), kJSPropertyAttributeNone, nullptr);
        JSStringRelease(key);
        JSObjectRef data = JSObjectMake(ctx, nullptr, nullptr);
        for (NSUInteger i = 0; i < length; i++) {
            JSValueRef oldValue = JSObjectGetPropertyAtIndex(ctx, array, (unsigned int)i, nullptr);
            JSObjectSetPropertyForKey(ctx, data, oldValue, oldValue, kJSPropertyAttributeNone, nullptr);
        }
        key = JSStringCreateWithUTF8CString("data");
        JSObjectSetProperty(ctx, result, key, data, kJSPropertyAttributeNone, nullptr);
        JSStringRelease(key);

        return result;
    }
    return JSValueMakeUndefined(ctx);
}

JSValueRef asyncBridgeImp(JSContextRef ctx, JSObjectRef function, JSObjectRef thisObject, size_t argumentCount, const JSValueRef arguments[], JSValueRef* exception) {
    if (argumentCount >= 4) {
        //读取参数1，字符串
        JSStringRef moduleName = JSValueToStringCopy(ctx, arguments[0], nullptr);
        NSLogJSStringRef(@"[asyncBridge] moduleName = %@", moduleName);
        
        //读取参数2，字符串
        JSStringRef method = JSValueToStringCopy(ctx, arguments[1], nullptr);
        NSLogJSStringRef(@"[asyncBridge] method = %@", method);
        
        //读取参数3，数组，遍历其内容
        JSObjectRef array = JSValueToObject(ctx, arguments[2], nullptr);
        NSUInteger length = JSValueToNumber(ctx, JSObjectGetProperty(ctx, array, JSStringCreateWithUTF8CString("length"), nullptr), nullptr);
        
        for (NSUInteger i = 0; i < length; i++) {
            NSLogJSStringRef([NSString stringWithFormat:@"[asyncBridge] array[%ld] %%@", i], JSValueToStringCopy(ctx, JSObjectGetPropertyAtIndex(ctx, array, (unsigned int)i, nullptr), nullptr));
        }
        
        //读取参数4，回掉
        JSObjectRef callback = JSValueToObject(ctx, arguments[3], nullptr);
        if (!JSObjectIsFunction(ctx, callback)) {
            return JSValueMakeUndefined(ctx);
        }
        
        //构成返回对象
        JSObjectRef result = JSObjectMake(ctx, nullptr, nullptr);
        JSObjectSetProperty(ctx, result, JSStringCreateWithUTF8CString("moduleName"), JSValueMakeString(ctx, moduleName),kJSPropertyAttributeNone, nullptr);
        JSObjectSetProperty(ctx, result, JSStringCreateWithUTF8CString("method"), JSValueMakeString(ctx, method), kJSPropertyAttributeNone, nullptr);
        JSObjectRef data = JSObjectMake(ctx, nullptr, nullptr);
        for (NSUInteger i = 0; i < length; i++) {
            JSValueRef oldValue = JSObjectGetPropertyAtIndex(ctx, array, (unsigned int)i, nullptr);
            JSObjectSetPropertyForKey(ctx, data, oldValue, oldValue, kJSPropertyAttributeNone, nullptr);
        }
        JSObjectSetProperty(ctx, result, JSStringCreateWithUTF8CString("data"), data, kJSPropertyAttributeNone, nullptr);
        
        JSValueProtect(ctx, callback);
        JSValueProtect(ctx, result);
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.0 * NSEC_PER_SEC)), webcore_queue(), ^{
            //调用callback，如果是自己创建的contextGroup，需要重新获取ctx
            //JSGlobalContextRef ctx = JSGlobalContextCreateInGroup(contextGroup, nullptr);
            JSValueRef args[1];
            args[0] = result;
            JSObjectCallAsFunction(ctx, callback, nullptr, 1, args, nullptr);
            
            JSValueUnprotect(ctx, callback);
            JSValueUnprotect(ctx, result);
        });
    }
    return JSValueMakeUndefined(ctx);
}

id JSValue2OCObject(JSContextRef ctx, JSValueRef value) {
    JSType type = JSValueGetType(ctx, value);
    switch (type) {
        case kJSTypeNumber:
            return @(JSValueToNumber(ctx, value, nullptr));
        case kJSTypeBoolean:
            return @(JSValueToBoolean(ctx, value));
        case kJSTypeString: {
            JSStringRef jsString = JSValueToStringCopy(ctx, value, nullptr);
            size_t maxBufferSize = JSStringGetMaximumUTF8CStringSize(jsString);
            char *utf8Buffer = new char[maxBufferSize];
            JSStringGetUTF8CString(jsString, utf8Buffer, maxBufferSize);
            NSString *str = [NSString stringWithUTF8String:utf8Buffer];
            delete [] utf8Buffer;
            JSStringRelease(jsString);
            return str;
        }
        case kJSTypeObject: {
            JSObjectRef obj = JSValueToObject(ctx, value, nullptr);
            if (JSValueIsArray(ctx, value)) {
                //array
                NSUInteger length = JSValueToNumber(ctx, JSObjectGetProperty(ctx, obj, JSStringCreateWithUTF8CString("length"), nullptr), nullptr);
                NSMutableArray *mArr = [NSMutableArray array];
                for (NSUInteger i = 0; i < length; i++) {
                    JSValueRef anyValue = JSObjectGetPropertyAtIndex(ctx, obj, (unsigned int)i, nullptr);
                    [mArr addObject:JSValue2OCObject(ctx, anyValue)];
                }
                return [mArr copy];
            } else if(JSValueIsObject(ctx, value)) {
                //object
                JSPropertyNameArrayRef keys = JSObjectCopyPropertyNames(ctx, obj);
                size_t count = JSPropertyNameArrayGetCount(keys);
                NSMutableDictionary *mDic = [NSMutableDictionary dictionary];
                for (size_t i = 0; i < count; i++) {
                    JSStringRef key = JSPropertyNameArrayGetNameAtIndex(keys, i);
                    JSValueRef anyValue = JSObjectGetProperty(ctx, obj, key, nullptr);
                    size_t maxBufferSize = JSStringGetMaximumUTF8CStringSize(key);
                    char *utf8Buffer = new char[maxBufferSize];
                    JSStringGetUTF8CString(key, utf8Buffer, maxBufferSize);
                    NSString *keyStr = [NSString stringWithUTF8String:utf8Buffer];
                    delete [] utf8Buffer;
                    [mDic setValue:JSValue2OCObject(ctx, anyValue) forKey:keyStr];
                }
                JSPropertyNameArrayRelease(keys);
                return [mDic copy];
            }
            //其他不能处理
            return [NSNull null];
        }
        case kJSTypeUndefined:
        case kJSTypeNull:
        case kJSTypeSymbol:
        default:
            return [NSNull null];
    }
    return [NSNull null];
}

JSValueRef data2nativeImp(JSContextRef ctx, JSObjectRef function, JSObjectRef thisObject, size_t argumentCount, const JSValueRef arguments[], JSValueRef* exception) {
    if (argumentCount >= 1) {
        JSValueRef value = arguments[0];
        JSValueProtect(ctx, value);
        id obj = JSValue2OCObject(ctx, value);
        JSValueUnprotect(ctx, value);
        //NSLog(@"[data2native] %@", obj);
    }
    return JSValueMakeUndefined(ctx);
}

JSValueRef json2nativeImp(JSContextRef ctx, JSObjectRef function, JSObjectRef thisObject, size_t argumentCount, const JSValueRef arguments[], JSValueRef* exception) {
    if (argumentCount >= 1) {
        NSString *string = JSStringRef2NSString(JSValueToStringCopy(ctx, arguments[0], nullptr));
        id obj = [NSJSONSerialization JSONObjectWithData:[string dataUsingEncoding:NSUTF8StringEncoding] options:0 error:nil];
        //NSLog(@"[json2native] %@", obj);
    }
    return JSValueMakeUndefined(ctx);
}

@implementation JscoreBridgeTester

- (void)main:(JSContext *)ctx {
    dispatch_async(webcore_queue(), ^{
        //contextGroup = JSContextGroupCreate();
        JSGlobalContextRef jscoreContext = ctx.JSGlobalContextRef;//JSGlobalContextCreateInGroup(contextGroup, nullptr);
        
        //获取js全局对象
        JSObjectRef globalObject = JSContextGetGlobalObject(jscoreContext);
        
        //注入say函数
        {
            JSStringRef fooName = JSStringCreateWithUTF8CString("say");//函数名
            JSObjectRef function = JSObjectMakeFunctionWithCallback(jscoreContext, fooName, &logImp);//函数指针指向的函数的实现
            JSObjectSetProperty(jscoreContext, globalObject, fooName, function, kJSPropertyAttributeNone, nullptr);
            JSStringRelease(fooName);
        }
        
        //注入datatonative函数
        {
            JSStringRef fooName = JSStringCreateWithUTF8CString("data2native");//函数名
            JSObjectRef function = JSObjectMakeFunctionWithCallback(jscoreContext, fooName, &data2nativeImp);//函数指针指向的函数的实现
            JSObjectSetProperty(jscoreContext, globalObject, fooName, function, kJSPropertyAttributeNone, nullptr);
            JSStringRelease(fooName);
        }
        
        //注入jsontonative函数
        {
            JSStringRef fooName = JSStringCreateWithUTF8CString("json2native");//函数名
            JSObjectRef function = JSObjectMakeFunctionWithCallback(jscoreContext, fooName, &json2nativeImp);//函数指针指向的函数的实现
            JSObjectSetProperty(jscoreContext, globalObject, fooName, function, kJSPropertyAttributeNone, nullptr);
            JSStringRelease(fooName);
        }
        
        //注入同步桥
        {
            JSStringRef fooName = JSStringCreateWithUTF8CString("syncBridge");//函数名
            JSObjectRef function = JSObjectMakeFunctionWithCallback(jscoreContext, fooName, &syncBridgeImp);//函数指针指向的函数的实现
            JSObjectSetProperty(jscoreContext, globalObject, fooName, function, kJSPropertyAttributeNone, nullptr);
            JSStringRelease(fooName);
        }
        
        //注入异步桥
        {
            JSStringRef fooName = JSStringCreateWithUTF8CString("asyncBridge");//函数名
            JSObjectRef function = JSObjectMakeFunctionWithCallback(jscoreContext, fooName, &asyncBridgeImp);//函数指针指向的函数的实现
            JSObjectSetProperty(jscoreContext, globalObject, fooName, function, kJSPropertyAttributeNone, nullptr);
            JSStringRelease(fooName);
        }
        
    });
}

- (void)dealloc {
}


@end
