#!/usr/bin/python

import sys,os
import struct
import binascii
import zlib

##filter function
def undo_filter_sub(filter_unit, scanline, previous, result):
  ai = 0
  for i in range(filter_unit, len(result)):
    x = scanline[i]
    a = result[ai]
    result[i] = (x + a) & 0xff
    ai += 1


def undo_filter_up(filter_unit, scanline, previous, result):
  for i in range(len(result)):
    x = scanline[i]
    b = previous[i]
    result[i] = (x + b) & 0xff


def undo_filter_average(filter_unit, scanline, previous, result):
  ai = -filter_unit
  for i in range(len(result)):
    x = scanline[i]
    if ai < 0:
      a = 0
    else:
      a = result[ai]
    b = previous[i]
    result[i] = (x + ((a + b) >> 1)) & 0xff
    ai += 1


def undo_filter_paeth(filter_unit, scanline, previous, result):
  ai = -filter_unit
  for i in range(len(result)):
    x = scanline[i]
    if ai < 0:
      a = c = 0
    else:
      a = result[ai]
      c = previous[ai]
    b = previous[i]
    p = a + b - c
    pa = abs(p - a)
    pb = abs(p - b)
    pc = abs(p - c)
    if pa <= pb and pa <= pc:
      pr = a
    elif pb <= pc:
      pr = b
    else:
      pr = c
    result[i] = (x + pr) & 0xff
    ai += 1

def undo_filter(colorsize, filter_type, scanline, previous):
  result = scanline

  if filter_type == 0:
    return result

  if len(previous) < 1:
    previous = bytearray([0] * len(scanline))

  fn = (None,
        undo_filter_sub,
        undo_filter_up,
        undo_filter_average,
        undo_filter_paeth)[filter_type]
  fn(colorsize, scanline, previous, result)
  return result

##filter function end

#main

#read input
readdata = ''

def read_block(rf):
  length = struct.unpack('>L', rf.read(4))[0]
  name = rf.read(4)
  data = rf.read(length)
  hash = rf.read(4)
  return name, data

rf = open("input.png", "rb")
rf.seek(2 * 4)

while 1:
  name, data = read_block(rf)
  if name == 'IDAT':
    readdata += data
  if name == 'IEND':
    break

decode = zlib.decompressobj()
result = decode.decompress(readdata)
result += decode.flush()

#decode filter
result_copy = ''

lastresult = bytearray()
for x in range(0, 694):
  linetype = result[((320 * 4 + 1) * x)]
  linedata = bytearray(result[((320 * 4 + 1) * x + 1):((320 * 4 + 1) * (x + 1))])
  lastresult = undo_filter(4, struct.unpack('>B', linetype)[0], linedata, lastresult)
  result_copy += struct.pack('B',0x00)
  result_copy += bytes(lastresult)

#result = result_copy

#read input end

#write

def write_block(f, title, data):
  f.write(struct.pack('>L',len(data)))
  f.write(title)
  f.write(data)
  f.write(struct.pack('>l',binascii.crc32(title + data)))

f = open("output.png", "wb")  

#png

f.write(struct.pack('>L',0x89504E47))
f.write(struct.pack('>L',0x0D0A1A0A))

#IHDR

ihdr = ""

ihdr += struct.pack('>L',320) #w
ihdr += struct.pack('>L',694) #h
ihdr += struct.pack('B',0x08) #depth
ihdr += struct.pack('B',0x06) #type

ihdr += struct.pack('B',0x00) #compression 
ihdr += struct.pack('B',0x00) #filter
ihdr += struct.pack('B',0x00) #interlace

write_block(f, "IHDR", ihdr)

#iDOT

idotpos = f.tell();
idotoffpos = f.tell() + 32
idotoffpos2 = f.tell() + 32 + 12

alll = 694
half = 264
first = alll - half - half
secend = alll - half


idot = ""
idot += struct.pack('>L',0x00000003)
idot += struct.pack('>L',0x00000000)
idot += struct.pack('>L',first) #h
idot += struct.pack('>L',0x00000028 + 12)

idot += struct.pack('>L',first) #h
idot += struct.pack('>L',half)
idot += struct.pack('>L',0xFFFFFFFF) #

idot += struct.pack('>L',secend) #h
idot += struct.pack('>L',half)
idot += struct.pack('>L',0xFFFFFFFF) #

write_block(f, "iDOT", idot)

#IDAT

def substr(str, s, e):
  return str[s:e]

zl1 = zlib.compressobj()

idat = substr(result, 0, (320 * 4 + 1) * first)

idat2 = zl1.compress(idat)
idat2 += zl1.flush(zlib.Z_FULL_FLUSH)

write_block(f, "IDAT", idat2)

#IDAT2

idat2pos = f.tell();

idat = substr(result_copy,(320 * 4 + 1) * secend, (320 * 4 + 1) * (secend + 1))
idat += substr(result, (320 * 4 + 1) * (secend + 1), (320 * 4 + 1) * alll)


idat3 = zl1.compress(idat)
idat3 += zl1.flush(zlib.Z_FULL_FLUSH)

write_block(f, "IDAT", idat3)

#IDAT3

idat3pos = f.tell();

idat = substr(result_copy,(320 * 4 + 1) * first, (320 * 4 + 1) * (first + 1))
idat += substr(result, (320 * 4 + 1) * (first + 1), (320 * 4 + 1) * secend)

idat3 = zl1.compress(idat)
idat3 += zl1.flush(zlib.Z_FINISH)

write_block(f, "IDAT", idat3)

#IEND

write_block(f, "IEND", "")

#rewrite idot pos
f.seek(idotoffpos2)
f.write(struct.pack('>L',idat2pos - idotpos))
f.seek(idotoffpos)
f.write(struct.pack('>L',idat3pos - idotpos))

f.close()

#write end

#normal png write


f = open("output_contrast.png", "wb")  

#png

f.write(struct.pack('>L',0x89504E47))
f.write(struct.pack('>L',0x0D0A1A0A))

#IHDR

ihdr = ""

ihdr += struct.pack('>L',320) #w
ihdr += struct.pack('>L',694) #h
ihdr += struct.pack('B',0x08) #depth
ihdr += struct.pack('B',0x06) #type

ihdr += struct.pack('B',0x00) #compression 
ihdr += struct.pack('B',0x00) #filter
ihdr += struct.pack('B',0x00) #interlace

write_block(f, "IHDR", ihdr)

#IDAT

zl1 = zlib.compressobj()

idat = result

idat2 = zl1.compress(idat)
idat2 += zl1.flush(zlib.Z_FINISH)

write_block(f, "IDAT", idat2)

#IEND

write_block(f, "IEND", "")

f.close()