package com.lrdcq.playground.ui;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ListView;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.lrdcq.playground.R;

import java.util.ArrayList;
import java.util.Random;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        FrameLayout frameLayout = new FrameLayout(this);
        frameLayout.setLayoutParams(new FrameLayout.LayoutParams(
                FrameLayout.LayoutParams.MATCH_PARENT,
                FrameLayout.LayoutParams.MATCH_PARENT));

        // 创建ListView
        ListView listView = new ListView(this);
        listView.setLayoutParams(new FrameLayout.LayoutParams(
                FrameLayout.LayoutParams.MATCH_PARENT,
                FrameLayout.LayoutParams.MATCH_PARENT));

        // 设置背景和文字颜色
        listView.setBackgroundColor(getResources().getColor(android.R.color.black));

        // 创建1-300的数字列表
        ArrayList<String> numbers = new ArrayList<>();
        for (int i = 1; i <= 300; i++) {
            numbers.add(String.valueOf(i * 3.1415926535));
        }

        // 创建适配器并设置给ListView
        ArrayAdapter<String> adapter = new ArrayAdapter<String>(
                this,
                android.R.layout.simple_list_item_1,
                numbers) {
            @Override
            public View getView(int position, View convertView, ViewGroup parent) {
                View view = super.getView(position, convertView, parent);
                TextView textView = (TextView) view.findViewById(android.R.id.text1);
                textView.setTextColor(getResources().getColor(android.R.color.white));
                textView.setGravity(android.view.Gravity.CENTER);
                Random random = new Random();// ignore_security_alert [ByDesign7.4]WeakPRNG
                textView.setBackgroundColor(Color.argb(128, random.nextInt(128) + 128, random.nextInt(128) + 128, random.nextInt(128) + 128));
                return view;
            }
        };

        listView.setAdapter(adapter);

        // 将ListView添加到FrameLayout
        frameLayout.addView(listView);

        GlassView glass = new GlassView(this);
        FrameLayout.LayoutParams layout = new FrameLayout.LayoutParams(
                FrameLayout.LayoutParams.MATCH_PARENT,
                FrameLayout.LayoutParams.WRAP_CONTENT);
        layout.setMargins(0, 300, 0, 0);
        glass.setLayoutParams(layout);
        glass.setPadding(10,10,10,10);
        frameLayout.addView(glass);

        TextView hello = new TextView(this);
        hello.setTypeface(Typeface.create("sans-serif-black", Typeface.NORMAL));
        hello.setText("23:59");
        hello.setTextSize(128);
        hello.getPaint().setFakeBoldText(true);
        hello.setLayoutParams(new FrameLayout.LayoutParams(FrameLayout.LayoutParams.WRAP_CONTENT, FrameLayout.LayoutParams.WRAP_CONTENT));
        glass.addView(hello);

        glass.setCameraDistance(getResources().getDisplayMetrics().density * 10000);
        ObjectAnimator shakeAnim = ObjectAnimator.ofFloat(
                hello,
                "rotationY",
                -20f,
                20f
        );
        shakeAnim.setDuration(5000);
        shakeAnim.setRepeatCount(ValueAnimator.INFINITE);
        shakeAnim.setRepeatMode(ValueAnimator.REVERSE);
        shakeAnim.setInterpolator(new AccelerateDecelerateInterpolator());
        shakeAnim.start();

        setContentView(frameLayout);
    }
}